/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge;

import com.ibm.hwmca.fw.bridge.IncomingServiceRequest;
import com.ibm.hwmca.fw.bridge.NativeBridgeException;
import com.ibm.hwmca.fw.bridge.NativeBridgeListener;
import com.ibm.hwmca.fw.bridge.OutgoingServiceRequest;
import com.ibm.hwmca.fw.bridge.request.CReqExit;
import com.ibm.hwmca.fw.bridge.request.CReqInvokeNativeFunctionByName;
import com.ibm.hwmca.fw.bridge.request.CReqInvokeNativeFunctionBySymbol;
import com.ibm.hwmca.fw.net.LocalSocket;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NativeBridge {
    private static final String TRACE_MASKT = "XNBRJNBT";
    private static final String TRACE_MASKF = "XNBRJNBF";
    private static final int FD_TO_C = 3;
    static Map globalObjectRegistry = new HashMap();
    Map localObjectRegistry = new HashMap();
    int autoNameIndex = 0;
    Object localObjectRegistryLock = new Object();
    static Map referencesToNativeBridge;
    static ReferenceQueue referencesQueue;
    static Object referencesLock;
    private WeakReference associatedReference;
    protected LocalSocket toChildProcess;
    protected NativeProcess nativeProcess;
    private boolean serverBridge;
    private ArrayList listeners;
    DataOutputStream out;
    protected Object writeLock = new Object();
    int outgoingRequestId = 0;
    Map outstandingRequests = new HashMap();

    public NativeBridge() {
        this.registerObject(this, "local.bridge");
    }

    NativeBridge(LocalSocket connection) throws IOException {
        this();
        this.serverBridge = true;
        this.initializeConnection(connection);
    }

    public static Object invokeNativeFunction(NativeProcessParameters processParms, String sharedObject, String symbol, Object[] arguments) throws IOException, NativeBridgeException {
        NativeBridge nativeBridge = new NativeBridge();
        nativeBridge.exec(processParms);
        Object result = nativeBridge.invokeNativeFunction(sharedObject, symbol, arguments);
        nativeBridge.sendRequestToExit();
        nativeBridge.close();
        return result;
    }

    public static Object invokeNativeFunction(NativeProcessParameters processParms, String registeredName, Object[] arguments) throws IOException, NativeBridgeException {
        NativeBridge nativeBridge = new NativeBridge();
        nativeBridge.exec(processParms);
        Object result = nativeBridge.invokeNativeFunction(registeredName, arguments);
        nativeBridge.sendRequestToExit();
        nativeBridge.close();
        return result;
    }

    public synchronized void exec(NativeProcessParameters processParms) throws IOException {
        if (this.toChildProcess != null) {
            throw new IllegalStateException("Native Bridge is already connected");
        }
        LocalSocket[] socketPair = LocalSocket.getSocketPair();
        processParms.addInheritedFd(socketPair[1].getFd(), 3);
        this.nativeProcess = NativeProcess.exec(processParms);
        socketPair[1].close();
        this.initializeConnection(socketPair[0]);
    }

    public int waitForNativeProcess() throws InterruptedException {
        return this.nativeProcess.waitFor();
    }

    public static synchronized void registerGlobalObject(Object object, String name) {
        globalObjectRegistry.put(name, object);
        Trace.trace(TRACE_MASKF, "Adding name \"" + name + "\" to global object registry." + "  Registry now has " + globalObjectRegistry.size() + " entries." + "  New item is of class \"" + object.getClass().getName() + "\"");
    }

    public static synchronized void deregisterGlobalObject(String name) {
        globalObjectRegistry.remove(name);
        Trace.trace(TRACE_MASKF, "Removing name \"" + name + "\" from global object registry." + "  Registry now has " + globalObjectRegistry.size() + " entries.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object object, String name) {
        Object object2 = this.localObjectRegistryLock;
        synchronized (object2) {
            this.localObjectRegistry.put(name, object);
            Trace.trace(TRACE_MASKF, "Adding name \"" + name + "\" to local object registry " + this.toString() + ".  Registry now has " + this.localObjectRegistry.size() + " entries." + "  New item is of class \"" + object.getClass().getName() + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerObject(Object object) {
        Object object2 = this.localObjectRegistryLock;
        synchronized (object2) {
            String name = "local." + this.autoNameIndex++;
            this.registerObject(object, name);
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObject(String name) {
        Object object = this.localObjectRegistryLock;
        synchronized (object) {
            this.localObjectRegistry.remove(name);
            Trace.trace(TRACE_MASKF, "Removing name \"" + name + "\" from local object registry " + this.toString() + ".  Registry now has " + this.localObjectRegistry.size() + " entries.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseWhenNotReferenced(Object object) {
        Object object2 = this;
        synchronized (object2) {
            if (this.associatedReference != null) {
                this.associatedReference.clear();
                this.associatedReference = null;
            }
        }
        if (object == null) {
            return;
        }
        object2 = referencesLock;
        synchronized (object2) {
            if (referencesToNativeBridge == null) {
                NativeBridge.initializeReferenceHandling();
            }
            NativeBridge nativeBridge = this;
            synchronized (nativeBridge) {
                this.associatedReference = new WeakReference<Object>(object, referencesQueue);
            }
        }
    }

    private synchronized void initializeConnection(LocalSocket connection) throws IOException {
        if (this.toChildProcess != null) {
            throw new IllegalStateException("Native Bridge is already connected");
        }
        this.toChildProcess = connection;
        Trace.trace(TRACE_MASKT, "Initializing NativeBridge socket connection " + this.toString() + " on fd==" + this.toChildProcess.getFd());
        this.out = new DataOutputStream(new BufferedOutputStream(this.toChildProcess.getOutputStream()));
        Thread serviceThread = new Thread((Runnable)new ServiceReader(this, this.serverBridge), "Native Bridge Socket Reader for fd==" + this.toChildProcess.getFd());
        if (!this.serverBridge) {
            serviceThread.setDaemon(true);
        }
        serviceThread.start();
        this.fireConnectionInitializedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeReferenceHandling() {
        Object object = referencesLock;
        synchronized (object) {
            referencesToNativeBridge = new HashMap();
            referencesQueue = new ReferenceQueue();
            Thread handler = new Thread(new Runnable(){

                public void run() {
                    NativeBridge.processAssociatedReferences();
                }
            }, "Native Bridge Reference Handler");
            handler.setDaemon(true);
            handler.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAssociatedReferences() {
        while (true) {
            NativeBridge bridge;
            Reference ref;
            try {
                ref = referencesQueue.remove();
            }
            catch (InterruptedException e) {
                continue;
            }
            Object object = referencesLock;
            synchronized (object) {
                bridge = (NativeBridge)referencesToNativeBridge.get(ref);
            }
            if (bridge == null) continue;
            bridge.close(new IOException("Associated reference was garbage collected"));
        }
    }

    public Object invokeNativeFunction(String sharedObject, String symbol, Object[] arguments) throws IOException, NativeBridgeException {
        CReqInvokeNativeFunctionBySymbol request = new CReqInvokeNativeFunctionBySymbol(this, sharedObject, symbol, arguments);
        this.sendOutgoingRequest(request);
        request.waitForResponse();
        return request.getFunctionResult();
    }

    public Object invokeNativeFunction(String registeredName, Object[] arguments) throws IOException, NativeBridgeException {
        CReqInvokeNativeFunctionByName request = new CReqInvokeNativeFunctionByName(this, registeredName, arguments);
        this.sendOutgoingRequest(request);
        request.waitForResponse();
        return request.getFunctionResult();
    }

    public void sendRequestToExit() throws IOException {
        CReqExit request = new CReqExit();
        this.sendOutgoingRequest(request);
    }

    public void close() {
        StringWriter buffer = new StringWriter();
        PrintWriter stack = new PrintWriter(buffer);
        new Exception("Stack trace").printStackTrace(stack);
        stack.flush();
        Trace.trace(TRACE_MASKT, "Call to close(), from:");
        Trace.trace(TRACE_MASKT, buffer.toString());
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(IOException e) {
        if (this.toChildProcess != null) {
            if (e == null) {
                Trace.trace(TRACE_MASKT, "Closing connection to C process for bridge " + this.toString());
            } else {
                Trace.trace(TRACE_MASKT, "Closing connection to C process for bridge " + this.toString() + ", using I/O exception:");
                if (!(e instanceof EOFException)) {
                    Trace.trace(TRACE_MASKT, e);
                }
            }
        }
        NativeBridge nativeBridge = this;
        synchronized (nativeBridge) {
            this.associatedReference = null;
            if (this.toChildProcess != null) {
                try {
                    this.toChildProcess.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
                this.toChildProcess = null;
            }
            Iterator iterator = this.outstandingRequests.values().iterator();
            while (iterator.hasNext()) {
                OutgoingServiceRequest request = (OutgoingServiceRequest)iterator.next();
                if (e == null) {
                    e = new IOException("Connection closed");
                }
                request.setResponseComplete(e);
            }
            this.outstandingRequests.clear();
        }
        this.fireConnectionClosingEvent(e);
    }

    protected void processIncomingRequest(final IncomingServiceRequest request) throws IOException {
        request.readRequest();
        if (request.isRequestQuick()) {
            request.executeRequest();
        } else {
            Thread requestThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        request.executeRequest();
                    }
                    catch (IOException e) {
                        Trace.trace(NativeBridge.TRACE_MASKT, "Got an I/O exception processing (non-quick) request from C code (id==" + request.getRequestId() + "):");
                        Trace.trace(NativeBridge.TRACE_MASKT, e);
                        NativeBridge.this.close(e);
                    }
                    catch (Throwable e) {
                        if (e instanceof ThreadDeath) {
                            throw (ThreadDeath)e;
                        }
                        Trace.trace(NativeBridge.TRACE_MASKT, "Got an unexpected exception processing (non-quick) request from C code (id==" + request.getRequestId() + "):");
                        Trace.trace(NativeBridge.TRACE_MASKT, e);
                        NativeBridge.this.close(new IOException(e.toString()));
                    }
                }
            }, "NativeBridge processing request " + request.getRequestId() + " for bridge " + this.toString());
            requestThread.start();
        }
    }

    public static synchronized Object lookupGlobalRegisteredObject(String name) {
        return globalObjectRegistry.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupLocalRegisteredObject(String name) {
        Object object = this.localObjectRegistryLock;
        synchronized (object) {
            return this.localObjectRegistry.get(name);
        }
    }

    public Object lookupRegisteredObject(String name) {
        Object o = this.lookupLocalRegisteredObject(name);
        if (o != null) {
            return o;
        }
        return NativeBridge.lookupGlobalRegisteredObject(name);
    }

    Object getWriteLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendOutgoingRequest(OutgoingServiceRequest request) throws IOException {
        request.setRequestId(this.outgoingRequestId++);
        Trace.trace(TRACE_MASKT, "Sending a request of type " + request.getClass().getName() + " to C code on bridge " + this.toString());
        Object object = this.getWriteLock();
        synchronized (object) {
            this.out.writeByte(1);
            this.out.writeInt(request.getRequestId());
            this.out.writeShort(request.getRequestCode());
            request.writeRequest(this.out);
            this.out.flush();
            if (request.getRequestCode() != 3) {
                this.outstandingRequests.put(new Integer(request.getRequestId()), request);
            }
        }
    }

    synchronized OutgoingServiceRequest removeOutstandingRequest(int requestId) {
        return (OutgoingServiceRequest)this.outstandingRequests.remove(new Integer(requestId));
    }

    public synchronized void addNativeBridgeListener(NativeBridgeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(listener);
    }

    public synchronized void removeNativeBridgeListener(NativeBridgeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private synchronized void fireConnectionInitializedEvent() {
        if (this.listeners == null) {
            return;
        }
        ArrayList listenersCopy = (ArrayList)this.listeners.clone();
        Iterator iterator = listenersCopy.iterator();
        while (iterator.hasNext()) {
            NativeBridgeListener listener = (NativeBridgeListener)iterator.next();
            listener.connectionEstablished(this);
        }
    }

    private synchronized void fireConnectionClosingEvent(IOException e) {
        if (this.listeners == null) {
            return;
        }
        ArrayList listenersCopy = (ArrayList)this.listeners.clone();
        Iterator iterator = listenersCopy.iterator();
        while (iterator.hasNext()) {
            NativeBridgeListener listener = (NativeBridgeListener)iterator.next();
            listener.connectionClosed(this, e);
        }
    }

    protected void finalize() throws Throwable {
        Trace.trace(TRACE_MASKT, "Closing Native Bridge connection due to finalization");
        this.close(null);
    }

    static {
        referencesLock = new Object();
    }

    private static class ServiceReader
    implements Runnable {
        WeakReference bridgeReference;
        NativeBridge strongBridgeReference;
        DataInputStream in;
        DataOutputStream out;

        public ServiceReader(NativeBridge bridge, boolean serverBridge) {
            this.bridgeReference = new WeakReference<NativeBridge>(bridge);
            if (serverBridge) {
                this.strongBridgeReference = bridge;
            }
        }

        public void run() {
            try {
                NativeBridge bridge = (NativeBridge)this.bridgeReference.get();
                if (bridge == null) {
                    return;
                }
                this.in = new DataInputStream(new BufferedInputStream(bridge.toChildProcess.getInputStream()));
                this.out = bridge.out;
                Trace.trace(NativeBridge.TRACE_MASKT, "Reading native bridge socket requests for bridge " + bridge.toString());
                block9: while (true) {
                    bridge = null;
                    byte packetType = this.in.readByte();
                    int requestId = this.in.readInt();
                    switch (packetType) {
                        case 1: {
                            Trace.trace(NativeBridge.TRACE_MASKT, "Got an incoming request from C code (id==" + requestId + ")");
                            int requestCode = this.in.readUnsignedShort();
                            bridge = (NativeBridge)this.bridgeReference.get();
                            if (bridge == null) {
                                return;
                            }
                            IncomingServiceRequest request = IncomingServiceRequest.createRequest(requestCode);
                            Trace.trace(NativeBridge.TRACE_MASKT, "Created request of type " + request.getClass().getName() + " for bridge " + bridge.toString());
                            request.setRequestId(requestId);
                            request.setInfo(bridge, this.in, this.out);
                            bridge.processIncomingRequest(request);
                            break;
                        }
                        case 2: {
                            OutgoingServiceRequest outstandingRequest;
                            Trace.trace(NativeBridge.TRACE_MASKT, "Got an incoming response from C code (to request id==" + requestId + ")");
                            bridge = (NativeBridge)this.bridgeReference.get();
                            if (bridge == null) {
                                return;
                            }
                            int statusCode = this.in.readInt();
                            Trace.trace(NativeBridge.TRACE_MASKT, "Response status code is " + statusCode + " (bridge " + bridge.toString() + ')');
                            String errorMessage = null;
                            boolean returnCodesSet = false;
                            int systemReturnCode = -1;
                            int componentReturnCode = -1;
                            if (statusCode != 0) {
                                errorMessage = this.in.readUTF();
                                Trace.trace(NativeBridge.TRACE_MASKT, "Response error message is \"" + errorMessage + "\"");
                                systemReturnCode = this.in.readInt();
                                componentReturnCode = this.in.readInt();
                                if (systemReturnCode != -1) {
                                    returnCodesSet = true;
                                }
                                if (returnCodesSet) {
                                    Trace.trace(NativeBridge.TRACE_MASKT, "Response system return code == " + systemReturnCode + ", component return code == " + componentReturnCode);
                                }
                            }
                            if ((outstandingRequest = bridge.removeOutstandingRequest(requestId)) == null) {
                                if (statusCode != 0) continue block9;
                                throw new IOException("Response to unknown request");
                            }
                            try {
                                outstandingRequest.setInfo(bridge, this.in, this.out);
                                if (statusCode == 0) {
                                    Trace.trace(NativeBridge.TRACE_MASKT, "Processing successful response");
                                    outstandingRequest.processSuccessfulResponse();
                                    outstandingRequest.setResponseComplete();
                                    break;
                                }
                                Trace.trace(NativeBridge.TRACE_MASKT, "Processing failed response");
                                outstandingRequest.processFailedResponse(statusCode, errorMessage);
                                if (returnCodesSet) {
                                    outstandingRequest.setFailedResponseReturnCodes(systemReturnCode, componentReturnCode);
                                }
                                outstandingRequest.setResponseComplete();
                                break;
                            }
                            catch (IOException e) {
                                Trace.trace(NativeBridge.TRACE_MASKT, "Got IOException processing response: " + e);
                                Trace.trace(NativeBridge.TRACE_MASKT, e);
                                outstandingRequest.setResponseComplete(e);
                                throw e;
                            }
                        }
                        default: {
                            throw new IOException("Unknown packet type.  Received byte of 0x" + Integer.toHexString(packetType & 0xFF) + " and request id of " + requestId);
                        }
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    Trace.trace(NativeBridge.TRACE_MASKT, "Native Bridge socket connection was closed (perhaps by peer)");
                } else {
                    Trace.trace(NativeBridge.TRACE_MASKT, "Got IOException in Java Native Bridge socket reader thread: " + e);
                    Trace.trace(NativeBridge.TRACE_MASKT, e);
                }
                NativeBridge bridge = (NativeBridge)this.bridgeReference.get();
                if (bridge == null) {
                    return;
                }
                bridge.close(e);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(NativeBridge.TRACE_MASKT, "Got Exception in Java Native Bridge socket reader thread: " + e);
                Trace.trace(NativeBridge.TRACE_MASKT, e);
                NativeBridge bridge = (NativeBridge)this.bridgeReference.get();
                if (bridge == null) {
                    return;
                }
                bridge.close(new IOException(e.toString()));
            }
        }
    }
}

